/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	TechPoints
**
** DESCRIPTION:	Maintains tech points
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef TECHPOINTS_H
#define TECHPOINTS_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int TechPoints_c_iInitialPoints = 99;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CTechPoints
{
public:

	//class structures
	struct SSaveState
	{
		int		m_iPoints;
	};

private:

	//class data
	int			m_iPoints;

	//class methods
	//setup
	public:		CTechPoints(void);
	public:		void Reset();
	public:		const bool LoadState(const SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState) const;

	// process

	// access
	public:		void Adjust(const int iAdj);
	public:		const int Points() const { return m_iPoints; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CTechPoints		TechPoints;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/